<?php
namespace Codemanas\ZoomWooCommerceAddon\Admin;
 
class AdminNoticeHandler {
	private static string $message = '';
	private static string $message_type = 'success';
	public static ?AdminNoticeHandler $instance = null;

	public static function get_instance(): ?AdminNoticeHandler {
		return is_null( self::$instance ) ? self::$instance = new self() : self::$instance;
	}

	public function __construct() {
		add_action( 'admin_notices', [ $this, 'show_message' ] );
	}

	private static function get_classes(): string {
		$classes = 'notice';
		switch ( self::$message_type ) {
			case 'error':
				$classes = 'notice notice-error';
				break;
			case 'success':
				$classes = 'notice notice-success';
				break;
			default:
				break;
		}

		return $classes;
	}

	public function show_message() {
		if ( empty( self::$message ) ) {
			return;
		}
		$class = self::get_classes();
		if ( self::$message != '' ) {
			printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), self::$message );
		}
	}

	public static function set_message( $message, $message_type ) {
		self::$message      = $message;
		self::$message_type = $message_type;
	}


}