<?php

namespace WPDesk\FCF\Pro\Validator\Rule;

use WPDesk\FCF\Pro\Settings\Option\DaysBeforeOption;
use WPDesk\FCF\Pro\Validator\Error\DateTooEarlyError;

/**
 * Checks that the date is not earlier than allowed.
 */
class DaysBeforeRule implements ValidatorRule {

	/**
	 * {@inheritdoc}
	 */
	public function validate_value( string $value, array $field_data ) {
		$days_before = $field_data[ DaysBeforeOption::FIELD_NAME ] ?? '';
		if ( $days_before === '' ) {
			return null;
		}

		$date_min = gmdate( 'Ymd', strtotime( sprintf( '%s -%s day', wp_date( 'Y-m-d H:i:s' ), $days_before ) ) );
		$dates    = ( $value ) ? explode( ',', $value ) : [];
		foreach ( $dates as $date ) {
			if ( gmdate( 'Ymd', strtotime( $date ) ) < $date_min ) {
				return new DateTooEarlyError( $field_data, $value );
			}
		}

		return null;
	}
}
